(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     32865,        899]*)
(*NotebookOutlinePosition[     33519,        922]*)
(*  CellTagsIndexPosition[     33475,        918]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
    \(\(nube = {{0, 1}, {1, 1.5}, {2, 1}, {4, 4}, {5, 3}, {6, 
            4}};\)\), "\n", 
    \(p[x_] = InterpolatingPolynomial[nube, x]\)}], "Input"],

Cell[BoxData[
    \(1 + \((\(\(0.5`\)\(\[InvisibleSpace]\)\) + \((\(-0.5`\) + \
\((\(\(0.29166666666666663`\)\(\[InvisibleSpace]\)\) + \
\((\(-0.13333333333333333`\) + 
                              0.049999999999999996`\ \((\(-5\) + 
                                    x)\))\)\ \((\(-4\) + x)\))\)\ \((\(-2\) + 
                        x)\))\)\ \((\(-1\) + x)\))\)\ x\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Expand[p[x]]\)], "Input"],

Cell[BoxData[
    \(1 + 4.6499999999999995`\ x - 7.141666666666666`\ x\^2 + 
      3.6749999999999994`\ x\^3 - 0.7333333333333333`\ x\^4 + 
      0.049999999999999996`\ x\^5\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(A = 
      Plot[0.5 + p[x], {x, \(-0.6\), 6.5}, AspectRatio \[Rule] Automatic, 
        PlotStyle \[Rule] {Thickness[0.004]}, PlotRange \[Rule] {0.5, 5}, 
        AxesOrigin \[Rule] {\(-0.5\), 0.9}, Ticks \[Rule] None, 
        AxesStyle \[Rule] {Thickness[0.003]}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .60362 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.104292 0.134138 -0.0670691 0.134138 [
[ -0.0015 -0.0015 0 0 ]
[ 1.0015 .60512 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.003 w
[ ] 0 setdash
0 .05366 m
1 .05366 L
s
.03722 0 m
.03722 .60362 L
s
0 0 m
1 0 L
1 .60362 L
0 .60362 L
closepath
clip
newpath
.004 w
.0819 0 m
.08255 .00573 L
.09396 .08016 L
.10458 .13547 L
.11508 .17834 L
.125 .20935 L
.1339 .23022 L
.1389 .23933 L
.14357 .24631 L
.1485 .25217 L
.15301 .25626 L
.15541 .25797 L
.15802 .2595 L
.16078 .26073 L
.16205 .26117 L
.16341 .26156 L
.16484 .26188 L
.16549 .26199 L
.16618 .26209 L
.16749 .26223 L
.16869 .26228 L
.16936 .26229 L
.17008 .26228 L
.17137 .2622 L
.17216 .26212 L
.17291 .26202 L
.17432 .26177 L
.17683 .26115 L
.17916 .26037 L
.18444 .25795 L
.18907 .25513 L
.19407 .25144 L
.2031 .24332 L
.22371 .21997 L
.26485 .16818 L
.28537 .1465 L
.29538 .13798 L
.30447 .13162 L
.30902 .12898 L
.31395 .12654 L
.31821 .1248 L
.32289 .12328 L
.32529 .12266 L
.32787 .12213 L
.32929 .12189 L
.33059 .12171 L
.33191 .12156 L
.33314 .12145 L
.33426 .12138 L
.33545 .12133 L
Mistroke
.33614 .12131 L
.33678 .1213 L
.33798 .12131 L
.33913 .12135 L
.34019 .12141 L
.34135 .1215 L
.34258 .12162 L
.34513 .12198 L
.34755 .12244 L
.35208 .12362 L
.35696 .12536 L
.36226 .1278 L
.37179 .13359 L
.3806 .14052 L
.3993 .16002 L
.41992 .18836 L
.46018 .25972 L
.49892 .33924 L
.54011 .42211 L
.56067 .4585 L
.57978 .48743 L
.59825 .50983 L
.6085 .51961 L
.61794 .52679 L
.62821 .53253 L
.63362 .53467 L
.63634 .53551 L
.63933 .53625 L
.64196 .53674 L
.64321 .53693 L
.64436 .53706 L
.64569 .53719 L
.64639 .53724 L
.64713 .53728 L
.64838 .53732 L
.64909 .53733 L
.64976 .53733 L
.65094 .53731 L
.6522 .53725 L
.65327 .53717 L
.65444 .53705 L
.65706 .53669 L
.65949 .53623 L
.66453 .53486 L
.67 .53276 L
.67993 .52738 L
.68959 .52024 L
.69851 .51209 L
.73788 .46131 L
.77573 .40125 L
Mistroke
.79679 .37107 L
.80677 .35943 L
.81604 .35094 L
.82065 .34771 L
.82555 .34512 L
.8269 .34457 L
.82836 .34405 L
.82964 .34368 L
.831 .34336 L
.83222 .34314 L
.83292 .34304 L
.83357 .34297 L
.83471 .3429 L
.83593 .34288 L
.8372 .34295 L
.83837 .34308 L
.83965 .3433 L
.84101 .34362 L
.8433 .34439 L
.84582 .34557 L
.84806 .34692 L
.85047 .3487 L
.85483 .35284 L
.8598 .35906 L
.86441 .3664 L
.87489 .38915 L
.88509 .4204 L
.89599 .46506 L
.90625 .5191 L
.91735 .59248 L
Mfstroke
.91735 .59248 m
.91861 .60362 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{275.813, 166.438},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004C0000YQ000`40O003h00O2goo00<007ooOol0
2Goo00<007ooOol0nGoo000;Ool00`00Oomoo`09Ool00`00Oomoo`3iOol000]oo`03001oogoo00Uo
o`03001oogoo0?Uoo`002goo00<007ooOol02Goo00<007ooOol0nGoo000;Ool00`00Oomoo`09Ool0
0`00Oomoo`3iOol000]oo`03001oogoo00Uoo`03001oogoo0?Uoo`002goo00<007ooOol02Woo00<0
07ooOol0n7oo000;Ool00`00Oomoo`0:Ool00`00Oomoo`3hOol000]oo`03001oogoo00Yoo`03001o
ogoo0?Qoo`002goo00<007ooOol02Woo00<007ooOol0n7oo000;Ool00`00Oomoo`0:Ool00`00Oomo
o`3hOol000]oo`03001oogoo00Yoo`03001oogoo0?Qoo`002goo00<007ooOol02Woo00<007ooOol0
n7oo000;Ool00`00Oomoo`0;Ool00`00Oomoo`3gOol000]oo`03001oogoo00]oo`03001oogoo0?Mo
o`0000=oo`000000o`0040000Goo000;Ool00`00Oomoo`0;Ool00`00Oomoo`3gOol000]oo`03001o
ogoo00]oo`03001oogoo0?Moo`002goo00<007ooOol02goo00<007ooOol0mgoo000;Ool00`00Oomo
o`0<Ool00`00Oomoo`3fOol000]oo`03001oogoo00aoo`03001oogoo0?Ioo`002goo00<007ooOol0
37oo00<007ooOol0mWoo000;Ool00`00Oomoo`0<Ool00`00Oomoo`3fOol000]oo`03001oogoo00ao
o`03001oogoo0?Ioo`002goo00<007ooOol037oo00<007ooOol0mWoo000;Ool00`00Oomoo`0=Ool0
0`00Oomoo`3eOol000]oo`03001oogoo00eoo`03001oogoo0?Eoo`002goo00<007ooOol03Goo00<0
07ooOol0mGoo000;Ool00`00Oomoo`0=Ool00`00Oomoo`3eOol000]oo`03001oogoo00eoo`03001o
ogoo0?Eoo`002goo00<007ooOol03Woo00<007ooOol0m7oo000;Ool00`00Oomoo`0>Ool00`00Oomo
o`3dOol000]oo`03001oogoo00ioo`03001oogoo0?Aoo`002goo00<007ooOol03Woo00<007ooOol0
m7oo000;Ool00`00Oomoo`0>Ool00`00Oomoo`0iOol:002aOol000]oo`03001oogoo00moo`03001o
ogoo03Ioo`8000Yoo`800:moo`002goo00<007ooOol03goo00<007ooOol0=7oo0P003Woo0P00[Goo
000;Ool00`00Oomoo`0?Ool00`00Oomoo`0bOol2000BOol00`00Oomoo`2ZOol000]oo`03001oogoo
00moo`03001oogoo035oo`03001oogoo01=oo`03001oogoo0:Uoo`002goo00<007ooOol047oo00<0
07ooOol0;Woo0P005goo00<007ooOol0Z7oo000;Ool00`00Oomoo`0@Ool00`00Oomoo`0]Ool00`00
Oomoo`0HOol00`00Oomoo`2WOol000]oo`03001oogoo011oo`03001oogoo02aoo`03001oogoo01Yo
o`03001oogoo0:Ioo`002goo00<007ooOol047oo00<007ooOol0:goo00<007ooOol077oo00<007oo
Ool0YGoo000;Ool00`00Oomoo`0AOol00`00Oomoo`0ZOol00`00Oomoo`0MOol00`00Oomoo`2TOol0
00]oo`03001oogoo015oo`03001oogoo02Uoo`03001oogoo01moo`03001oogoo0:=oo`002goo00<0
07ooOol04Goo00<007ooOol0:7oo00<007ooOol08Goo00<007ooOol0XWoo000;Ool00`00Oomoo`0A
Ool00`00Oomoo`0WOol00`00Oomoo`0SOol00`00Oomoo`2QOol000]oo`03001oogoo019oo`03001o
ogoo02Eoo`03001oogoo02Aoo`03001oogoo0:5oo`002goo00<007ooOol04Woo00<007ooOol097oo
00<007ooOol09Woo00<007ooOol0X7oo000;Ool00`00Oomoo`0BOol00`00Oomoo`0TOol00`00Oomo
o`0WOol00`00Oomoo`2OOol000]oo`03001oogoo019oo`03001oogoo02=oo`03001oogoo02Uoo`03
001oogoo09ioo`002goo00<007ooOol04goo00<007ooOol08Goo00<007ooOol0:Woo00<007ooOol0
WWoo000;Ool00`00Oomoo`0COol00`00Oomoo`0POol00`00Oomoo`0/Ool00`00Oomoo`2MOol000]o
o`03001oogoo01=oo`03001oogoo021oo`03001oogoo02eoo`03001oogoo09aoo`002goo00<007oo
Ool057oo00<007ooOol07Woo00<007ooOol0;Woo00<007ooOol0W7oo000;Ool00`00Oomoo`0DOol0
0`00Oomoo`0MOol00`00Oomoo`0`Ool00`00Oomoo`2KOol000]oo`03001oogoo01Aoo`03001oogoo
01aoo`03001oogoo035oo`03001oogoo09]oo`002goo00<007ooOol05Goo00<007ooOol06Woo00<0
07ooOol0<goo00<007ooOol0VWoo000;Ool00`00Oomoo`0EOol00`00Oomoo`0JOol00`00Oomoo`0c
Ool00`00Oomoo`2JOol000]oo`03001oogoo01Eoo`03001oogoo01Uoo`03001oogoo03Eoo`03001o
ogoo09Uoo`002goo00<007ooOol05Woo00<007ooOol05goo00<007ooOol0=goo00<007ooOol0V7oo
000;Ool00`00Oomoo`0FOol00`00Oomoo`0FOol00`00Oomoo`0hOol00`00Oomoo`2HOol000]oo`03
001oogoo01Moo`03001oogoo01Aoo`03001oogoo03Yoo`03001oogoo09Moo`002goo00<007ooOol0
5goo00<007ooOol04goo00<007ooOol0>goo00<007ooOol0Ugoo000;Ool00`00Oomoo`0GOol00`00
Oomoo`0COol00`00Oomoo`0lOol00`00Oomoo`2FOol000]oo`03001oogoo01Qoo`03001oogoo015o
o`03001oogoo03ioo`03001oogoo09Eoo`002goo00<007ooOol067oo00<007ooOol047oo00<007oo
Ool0?goo00<007ooOol0UGoo000;Ool00`00Oomoo`0IOol00`00Oomoo`0>Ool00`00Oomoo`11Ool0
0`00Oomoo`2DOol000]oo`03001oogoo01Yoo`03001oogoo00]oo`8004Aoo`03001oogoo09Aoo`00
2goo00<007ooOol06goo00<007ooOol02Goo00<007ooOol0AGoo00<007ooOol0Tgoo000;Ool00`00
Oomoo`0LOol00`00Oomoo`07Ool00`00Oomoo`16Ool00`00Oomoo`2COol000]oo`03001oogoo01eo
o`8000Aoo`<004Yoo`03001oogoo099oo`002goo00<007ooOol07Woo1P00CGoo00<007ooOol0TGoo
000;Ool00`00Oomoo`1aOol00`00Oomoo`2AOol000]oo`03001oogoo079oo`03001oogoo091oo`00
2goo00<007ooOol0LWoo00<007ooOol0T7oo000;Ool00`00Oomoo`1cOol00`00Oomoo`2?Ool000]o
o`03001oogoo07=oo`03001oogoo08moo`002goo00<007ooOol0M7oo00<007ooOol0SWoo000;Ool0
0`00Oomoo`1dOol00`00Oomoo`2>Ool000]oo`03001oogoo07Eoo`03001oogoo08eoo`002goo00<0
07ooOol0MGoo00<007ooOol0SGoo000;Ool00`00Oomoo`1fOol00`00Oomoo`2<Ool000]oo`03001o
ogoo07Ioo`03001oogoo08aoo`002goo00<007ooOol0Mgoo00<007ooOol0Rgoo000;Ool00`00Oomo
o`1gOol00`00Oomoo`2;Ool000]oo`03001oogoo07Qoo`03001oogoo08Yoo`002goo00<007ooOol0
N7oo00<007ooOol0RWoo000;Ool00`00Oomoo`1iOol00`00Oomoo`29Ool000]oo`03001oogoo07Uo
o`03001oogoo08Uoo`002goo00<007ooOol0NWoo00<007ooOol0R7oo000;Ool00`00Oomoo`1jOol0
0`00Oomoo`28Ool000]oo`03001oogoo07]oo`03001oogoo08Moo`002goo00<007ooOol0Ngoo00<0
07ooOol0Qgoo000;Ool00`00Oomoo`1kOol00`00Oomoo`1FOol6000[Ool000]oo`03001oogoo07ao
o`03001oogoo05=oo`<000Aoo`8002Yoo`002goo00<007ooOol0O7oo00<007ooOol0DWoo00<007oo
Ool01Woo0P00:Goo000;Ool00`00Oomoo`1mOol00`00Oomoo`1@Ool00`00Oomoo`09Ool00`00Oomo
o`0VOol000]oo`03001oogoo07eoo`03001oogoo04moo`03001oogoo00]oo`03001oogoo02Eoo`00
2goo00<007ooOol0OWoo00<007ooOol0CGoo00<007ooOol03Goo00<007ooOol097oo000;Ool00`00
Oomoo`1nOol00`00Oomoo`1=Ool00`00Oomoo`0=Ool00`00Oomoo`0TOol000]oo`03001oogoo07mo
o`03001oogoo04]oo`03001oogoo00ioo`03001oogoo02Aoo`002goo00<007ooOol0Ogoo00<007oo
Ool0BWoo00<007ooOol047oo00<007ooOol08goo000;Ool00`00Oomoo`20Ool00`00Oomoo`18Ool0
0`00Oomoo`0AOol00`00Oomoo`0SOol000]oo`03001oogoo081oo`03001oogoo04Qoo`03001oogoo
019oo`03001oogoo029oo`002goo00<007ooOol0PGoo00<007ooOol0AWoo00<007ooOol04goo00<0
07ooOol08Woo000;Ool00`00Oomoo`21Ool00`00Oomoo`15Ool00`00Oomoo`0EOol00`00Oomoo`0Q
Ool000]oo`03001oogoo089oo`03001oogoo04=oo`03001oogoo01Ioo`03001oogoo025oo`002goo
00<007ooOol0PWoo00<007ooOol0@goo00<007ooOol05Woo00<007ooOol08Goo000;Ool00`00Oomo
o`23Ool00`00Oomoo`11Ool00`00Oomoo`0HOol00`00Oomoo`0POol000]oo`03001oogoo08=oo`03
001oogoo041oo`03001oogoo01Uoo`03001oogoo021oo`002goo00<007ooOol0Q7oo00<007ooOol0
?Woo00<007ooOol06goo00<007ooOol07goo000;Ool00`00Oomoo`24Ool00`00Oomoo`0nOol00`00
Oomoo`0KOol00`00Oomoo`0OOol000]oo`03001oogoo08Eoo`03001oogoo03aoo`03001oogoo01ao
o`03001oogoo01moo`002goo00<007ooOol0QGoo00<007ooOol0?7oo00<007ooOol07Goo00<007oo
Ool07Woo000;Ool00`00Oomoo`26Ool00`00Oomoo`0jOol00`00Oomoo`0NOol00`00Oomoo`0NOol0
00]oo`03001oogoo08Ioo`03001oogoo03Uoo`03001oogoo01moo`03001oogoo01ioo`002goo00<0
07ooOol0Qgoo00<007ooOol0>7oo00<007ooOol087oo00<007ooOol07Goo000;Ool00`00Oomoo`27
Ool00`00Oomoo`0gOol00`00Oomoo`0QOol00`00Oomoo`0MOol000]oo`03001oogoo08Qoo`03001o
ogoo03Eoo`03001oogoo029oo`03001oogoo01eoo`002goo00<007ooOol0R7oo00<007ooOol0=Goo
00<007ooOol08Woo00<007ooOol07Goo000;Ool00`00Oomoo`29Ool00`00Oomoo`0cOol00`00Oomo
o`0TOol00`00Oomoo`0LOol000]oo`03001oogoo08Uoo`03001oogoo03=oo`03001oogoo02Aoo`03
001oogoo01aoo`002goo00<007ooOol0RWoo00<007ooOol0<Goo00<007ooOol09Goo00<007ooOol0
77oo000;Ool00`00Oomoo`2:Ool00`00Oomoo`0`Ool00`00Oomoo`0VOol00`00Oomoo`0LOol000]o
o`03001oogoo08]oo`03001oogoo02moo`03001oogoo02Moo`03001oogoo01]oo`002goo00<007oo
Ool0Rgoo00<007ooOol0;Woo00<007ooOol0:7oo00<007ooOol06goo000;Ool00`00Oomoo`2<Ool0
0`00Oomoo`0/Ool00`00Oomoo`0YOol00`00Oomoo`0KOol000]oo`03001oogoo08eoo`03001oogoo
02Yoo`03001oogoo02Yoo`03001oogoo01]oo`002goo00<007ooOol0SWoo00<007ooOol0:Goo00<0
07ooOol0:Woo00<007ooOol06goo000;Ool00`00Oomoo`2>Ool00`00Oomoo`0XOol00`00Oomoo`0/
Ool00`00Oomoo`0JOol000]oo`03001oogoo08moo`03001oogoo02Ioo`03001oogoo02eoo`03001o
ogoo01Yoo`002goo00<007ooOol0T7oo00<007ooOol097oo00<007ooOol0;Woo00<007ooOol06Woo
000;Ool00`00Oomoo`2AOol00`00Oomoo`0SOol00`00Oomoo`0^Ool00`00Oomoo`0JOol000]oo`03
001oogoo099oo`03001oogoo025oo`03001oogoo02moo`03001oogoo01Yoo`002goo00<007ooOol0
TWoo00<007ooOol087oo00<007ooOol0<Goo00<007ooOol06Goo000;Ool00`00Oomoo`2COol00`00
Oomoo`0NOol00`00Oomoo`0bOol00`00Oomoo`0IOol000]oo`03001oogoo09Aoo`03001oogoo01ao
o`03001oogoo03=oo`03001oogoo01Uoo`002goo00<007ooOol0UGoo00<007ooOol06goo00<007oo
Ool0<goo00<007ooOol06Goo000;Ool00`00Oomoo`2EOol00`00Oomoo`0JOol00`00Oomoo`0dOol0
0`00Oomoo`0IOol000]oo`03001oogoo09Ioo`03001oogoo01Qoo`03001oogoo03Ioo`03001oogoo
01Qoo`002goo00<007ooOol0Ugoo00<007ooOol05Woo00<007ooOol0=goo00<007ooOol067oo000;
Ool00`00Oomoo`2HOol00`00Oomoo`0DOol00`00Oomoo`0hOol00`00Oomoo`0HOol000]oo`03001o
ogoo09Uoo`80019oo`8003]oo`03001oogoo01Qoo`002goo00<007ooOol0Vgoo00<007ooOol03Woo
00<007ooOol0>goo00<007ooOol067oo000;Ool00`00Oomoo`2LOol2000<Ool2000nOol00`00Oomo
o`0HOol000]oo`03001oogoo09ioo`8000Moo`<0045oo`03001oogoo01Moo`002goo00<007ooOol0
X7oo1`00A7oo00<007ooOol05goo000;Ool00`00Oomoo`3[Ool00`00Oomoo`0GOol000]oo`03001o
ogoo0>]oo`03001oogoo01Moo`002goo00<007ooOol0jgoo00<007ooOol05goo000;Ool00`00Oomo
o`3[Ool00`00Oomoo`0GOol000]oo`03001oogoo0>]oo`03001oogoo01Moo`002goo00<007ooOol0
k7oo00<007ooOol05Woo000;Ool00`00Oomoo`3/Ool00`00Oomoo`0FOol000]oo`03001oogoo0>ao
o`03001oogoo01Ioo`002goo00<007ooOol0k7oo00<007ooOol05Woo000;Ool00`00Oomoo`3/Ool0
0`00Oomoo`0FOol000]oo`03001oogoo0>aoo`03001oogoo01Ioo`002goo00<007ooOol0kGoo00<0
07ooOol05Goo000;Ool00`00Oomoo`3]Ool00`00Oomoo`0EOol000]oo`03001oogoo0>eoo`03001o
ogoo01Eoo`002goo00<007ooOol0kGoo00<007ooOol05Goo000;Ool00`00Oomoo`3]Ool00`00Oomo
o`0EOol000]oo`03001oogoo0>eoo`03001oogoo01Eoo`002goo00<007ooOol0kGoo00<007ooOol0
5Goo0000\
\>"],
  ImageRangeCache->{{{0, 274.813}, {165.438, 0}} -> {-0.806096, 0.488818, \
0.0273357, 0.0273357}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(B = {Text[a1, {0.15, 0.85 + p[0.65]}], Text[a2, {1.4, 0.13 + p[1.5]}], 
        Text[a3, {3.6, 0.75 + p[4]}], Text[a4, {5.1, p[5.2]}], 
        Text[a5, {2.8, 2}]}\)], "Input"],

Cell[BoxData[
    \({Text[a1, {0.15`, 2.739289578125`}], Text[a2, {1.4`, 1.1065625`}], 
      Text[a3, {3.6`, 4.749999999999999`}], 
      Text[a4, {5.1`, 2.7205759999999963`}], Text[a5, {2.8`, 2}]}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[A, Graphics[B]]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .60362 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.104292 0.134138 -0.0670691 0.134138 [
[ -0.0015 -0.0015 0 0 ]
[ 1.0015 .60512 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.003 w
[ ] 0 setdash
0 .05366 m
1 .05366 L
s
.03722 0 m
.03722 .60362 L
s
0 0 m
1 0 L
1 .60362 L
0 .60362 L
closepath
clip
newpath
.004 w
.0819 0 m
.08255 .00573 L
.09396 .08016 L
.10458 .13547 L
.11508 .17834 L
.125 .20935 L
.1339 .23022 L
.1389 .23933 L
.14357 .24631 L
.1485 .25217 L
.15301 .25626 L
.15541 .25797 L
.15802 .2595 L
.16078 .26073 L
.16205 .26117 L
.16341 .26156 L
.16484 .26188 L
.16549 .26199 L
.16618 .26209 L
.16749 .26223 L
.16869 .26228 L
.16936 .26229 L
.17008 .26228 L
.17137 .2622 L
.17216 .26212 L
.17291 .26202 L
.17432 .26177 L
.17683 .26115 L
.17916 .26037 L
.18444 .25795 L
.18907 .25513 L
.19407 .25144 L
.2031 .24332 L
.22371 .21997 L
.26485 .16818 L
.28537 .1465 L
.29538 .13798 L
.30447 .13162 L
.30902 .12898 L
.31395 .12654 L
.31821 .1248 L
.32289 .12328 L
.32529 .12266 L
.32787 .12213 L
.32929 .12189 L
.33059 .12171 L
.33191 .12156 L
.33314 .12145 L
.33426 .12138 L
.33545 .12133 L
Mistroke
.33614 .12131 L
.33678 .1213 L
.33798 .12131 L
.33913 .12135 L
.34019 .12141 L
.34135 .1215 L
.34258 .12162 L
.34513 .12198 L
.34755 .12244 L
.35208 .12362 L
.35696 .12536 L
.36226 .1278 L
.37179 .13359 L
.3806 .14052 L
.3993 .16002 L
.41992 .18836 L
.46018 .25972 L
.49892 .33924 L
.54011 .42211 L
.56067 .4585 L
.57978 .48743 L
.59825 .50983 L
.6085 .51961 L
.61794 .52679 L
.62821 .53253 L
.63362 .53467 L
.63634 .53551 L
.63933 .53625 L
.64196 .53674 L
.64321 .53693 L
.64436 .53706 L
.64569 .53719 L
.64639 .53724 L
.64713 .53728 L
.64838 .53732 L
.64909 .53733 L
.64976 .53733 L
.65094 .53731 L
.6522 .53725 L
.65327 .53717 L
.65444 .53705 L
.65706 .53669 L
.65949 .53623 L
.66453 .53486 L
.67 .53276 L
.67993 .52738 L
.68959 .52024 L
.69851 .51209 L
.73788 .46131 L
.77573 .40125 L
Mistroke
.79679 .37107 L
.80677 .35943 L
.81604 .35094 L
.82065 .34771 L
.82555 .34512 L
.8269 .34457 L
.82836 .34405 L
.82964 .34368 L
.831 .34336 L
.83222 .34314 L
.83292 .34304 L
.83357 .34297 L
.83471 .3429 L
.83593 .34288 L
.8372 .34295 L
.83837 .34308 L
.83965 .3433 L
.84101 .34362 L
.8433 .34439 L
.84582 .34557 L
.84806 .34692 L
.85047 .3487 L
.85483 .35284 L
.8598 .35906 L
.86441 .3664 L
.87489 .38915 L
.88509 .4204 L
.89599 .46506 L
.90625 .5191 L
.91735 .59248 L
Mfstroke
.91735 .59248 m
.91861 .60362 L
s
gsave
.12441 .30037 -69 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.875 translate 1 -1 scale
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a1) show
1.000 setlinewidth
grestore
gsave
.29209 .08136 -69 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.875 translate 1 -1 scale
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a2) show
1.000 setlinewidth
grestore
gsave
.58719 .57009 -69 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.875 translate 1 -1 scale
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a3) show
1.000 setlinewidth
grestore
gsave
.7884 .29786 -69 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.875 translate 1 -1 scale
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a4) show
1.000 setlinewidth
grestore
gsave
.47988 .20121 -69 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.875 translate 1 -1 scale
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a5) show
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 173.813},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000[A000`40O003h00O2goo00<007ooOol0
2Woo00<007ooOol0ogoo1Woo000;Ool00`00Oomoo`0:Ool00`00Oomoo`3oOol6Ool000]oo`03001o
ogoo00Yoo`03001oogoo0?moo`Ioo`002goo00<007ooOol02Woo00<007ooOol0ogoo1Woo000;Ool0
0`00Oomoo`0:Ool00`00Oomoo`3oOol6Ool000]oo`03001oogoo00Yoo`03001oogoo0?moo`Ioo`00
2goo00<007ooOol02goo00<007ooOol0ogoo1Goo000;Ool00`00Oomoo`0;Ool00`00Oomoo`3oOol5
Ool000]oo`03001oogoo00]oo`03001oogoo0?moo`Eoo`002goo00<007ooOol02goo00<007ooOol0
ogoo1Goo000;Ool00`00Oomoo`0;Ool00`00Oomoo`3oOol5Ool000]oo`03001oogoo00]oo`03001o
ogoo0?moo`Eoo`002goo00<007ooOol02goo00<007ooOol0ogoo1Goo000;Ool00`00Oomoo`0<Ool0
0`00Oomoo`3oOol4Ool000]oo`03001oogoo00aoo`03001oogoo0?moo`Aoo`0000=oo`000000o`00
70000Woo000;Ool00`00Oomoo`0<Ool00`00Oomoo`3oOol4Ool000]oo`03001oogoo00aoo`03001o
ogoo0?moo`Aoo`002goo00<007ooOol037oo00<007ooOol0ogoo17oo000;Ool00`00Oomoo`0<Ool0
0`00Oomoo`3oOol4Ool000]oo`03001oogoo00eoo`03001oogoo0?moo`=oo`002goo00<007ooOol0
3Goo00<007ooOol0ogoo0goo000;Ool00`00Oomoo`0=Ool00`00Oomoo`0aOol500000goo00000002
0037Ool000]oo`03001oogoo00eoo`03001oogoo035oo`@0009oo`03001oogoo0<Qoo`002goo00<0
07ooOol03Goo00<007ooOol0=7oo00D007ooOomoo`000<Uoo`002goo00<007ooOol03Goo00<007oo
Ool0<Woo0`0017oo00<007ooOol0aWoo000;Ool00`00Oomoo`0>Ool00`00Oomoo`0fOol01000Oomo
o`00agoo000;Ool00`00Oomoo`0>Ool00`00Oomoo`0gOol20038Ool000]oo`03001oogoo00ioo`03
001oogoo0?moo`9oo`002goo00<007ooOol03Woo00<007ooOol0ogoo0Woo000;Ool00`00Oomoo`0>
Ool00`00Oomoo`3oOol2Ool000]oo`03001oogoo00moo`03001oogoo0?moo`5oo`002goo00<007oo
Ool03goo00<007ooOol0ogoo0Goo000;Ool00`00Oomoo`0?Ool00`00Oomoo`3oOol1Ool000]oo`03
001oogoo00moo`03001oogoo0?moo`5oo`002goo00<007ooOol03goo00<007ooOol0?7oo2P00^Woo
000;Ool00`00Oomoo`0?Ool00`00Oomoo`0jOol2000:Ool2002hOol000]oo`03001oogoo011oo`03
001oogoo03Moo`8000ioo`800;Ioo`002goo00<007ooOol047oo00<007ooOol0=Goo0P004Woo00<0
07ooOol0/goo000;Ool00`00Oomoo`0@Ool00`00Oomoo`0dOol00`00Oomoo`0COol2002cOol000]o
o`03001oogoo011oo`03001oogoo03=oo`03001oogoo01Ioo`03001oogoo0;1oo`002goo00<007oo
Ool04Goo00<007ooOol0<Goo00<007ooOol067oo00<007ooOol0[goo000;Ool00`00Oomoo`0AOol0
0`00Oomoo`0`Ool00`00Oomoo`0JOol00`00Oomoo`2^Ool000]oo`03001oogoo015oo`03001oogoo
02moo`03001oogoo01]oo`03001oogoo0:ioo`002goo00<007ooOol04Goo00<007ooOol0;Woo00<0
07ooOol07Goo00<007ooOol0[Goo000;Ool00`00Oomoo`0BOol00`00Oomoo`0/Ool00`00Oomoo`0O
Ool00`00Oomoo`2/Ool000]oo`03001oogoo019oo`03001oogoo02]oo`03001oogoo025oo`03001o
ogoo0:]oo`002goo00<007ooOol04Woo00<007ooOol0:Woo00<007ooOol08goo00<007ooOol0ZWoo
000;Ool00`00Oomoo`0BOol00`00Oomoo`0YOol00`00Oomoo`0UOol00`00Oomoo`2YOol000]oo`03
001oogoo01=oo`03001oogoo02Moo`03001oogoo02Ioo`03001oogoo0:Uoo`002goo00<007ooOol0
4goo00<007ooOol09Woo00<007ooOol0:7oo00<007ooOol0Z7oo000;Ool00`00Oomoo`0COol00`00
Oomoo`0VOol00`00Oomoo`0YOol00`00Oomoo`2WOol000]oo`03001oogoo01=oo`03001oogoo02Eo
o`03001oogoo02]oo`03001oogoo0:Ioo`002goo00<007ooOol057oo00<007ooOol08goo00<007oo
Ool0;7oo00<007ooOol0YWoo000;Ool00`00Oomoo`0DOol00`00Oomoo`0ROol00`00Oomoo`0^Ool0
0`00Oomoo`2UOol000]oo`03001oogoo01Aoo`03001oogoo025oo`03001oogoo031oo`03001oogoo
0:Aoo`002goo00<007ooOol05Goo00<007ooOol087oo00<007ooOol0<7oo00<007ooOol027oo1@00
0Woo0P00Tgoo000;Ool00`00Oomoo`0EOol00`00Oomoo`0OOol00`00Oomoo`0bOol00`00Oomoo`07
Ool40002Ool01000Oomoo`00TWoo000;Ool00`00Oomoo`0EOol00`00Oomoo`0NOol00`00Oomoo`0c
Ool00`00Oomoo`0:Ool00`00Oomoo`03Ool00`00Oomoo`2@Ool000]oo`03001oogoo01Ioo`03001o
ogoo01aoo`03001oogoo03Eoo`03001oogoo00Moo`<000=oo`8009=oo`002goo00<007ooOol05Woo
00<007ooOol06goo00<007ooOol0=goo00<007ooOol037oo00<007ooOol0TWoo000;Ool00`00Oomo
o`0GOol00`00Oomoo`0JOol00`00Oomoo`0gOol00`00Oomoo`0<Ool3002BOol000]oo`03001oogoo
01Moo`03001oogoo01Uoo`03001oogoo03Uoo`03001oogoo0:1oo`002goo00<007ooOol067oo00<0
07ooOol05goo00<007ooOol0>Woo00<007ooOol0X7oo000;Ool00`00Oomoo`0HOol00`00Oomoo`0F
Ool00`00Oomoo`0lOol00`00Oomoo`2OOol000]oo`03001oogoo01Uoo`03001oogoo01Aoo`03001o
ogoo03ioo`03001oogoo09ioo`002goo00<007ooOol06Goo00<007ooOol04goo00<007ooOol0?goo
00<007ooOol0WWoo000;Ool00`00Oomoo`0JOol00`00Oomoo`0AOol00`00Oomoo`11Ool00`00Oomo
o`2MOol000]oo`03001oogoo01Yoo`03001oogoo011oo`03001oogoo049oo`03001oogoo09eoo`00
2goo00<007ooOol06goo00<007ooOol03Woo00<007ooOol0A7oo00<007ooOol0W7oo000;Ool00`00
Oomoo`0KOol00`00Oomoo`0=Ool00`00Oomoo`16Ool00`00Oomoo`2KOol000]oo`03001oogoo01ao
o`03001oogoo00aoo`03001oogoo04Ioo`03001oogoo09]oo`002goo00<007ooOol07Goo00<007oo
Ool02Goo0P00BWoo00<007ooOol0VWoo000;Ool00`00Oomoo`0NOol00`00Oomoo`07Ool00`00Oomo
o`1:Ool00`00Oomoo`2JOol000]oo`03001oogoo01moo`8000Eoo`8004ioo`03001oogoo09Uoo`00
2goo00<007ooOol08Goo1@00D7oo00<007ooOol0VGoo000;Ool00`00Oomoo`1gOol00`00Oomoo`2H
Ool000]oo`03001oogoo07Moo`03001oogoo09Qoo`002goo00<007ooOol0N7oo00<007ooOol0Ugoo
000;Ool00`00Oomoo`1hOol00`00Oomoo`2GOol000]oo`03001oogoo07Uoo`03001oogoo09Ioo`00
2goo00<007ooOol0NGoo00<007ooOol0UWoo000;Ool00`00Oomoo`1jOol00`00Oomoo`2EOol000]o
o`03001oogoo07Yoo`03001oogoo055oo`D000=oo`<003Uoo`002goo00<007ooOol04Goo1@0000=o
o`0000000`00Ggoo00<007ooOol0D7oo10001Goo00<007ooOol0>7oo000;Ool00`00Oomoo`0AOol4
0004Ool00`00Oomoo`1OOol00`00Oomoo`1COol00`00Oomoo`05000iOol000]oo`03001oogoo01Ao
o`03001oogoo009oo`03001oogoo061oo`03001oogoo051oo`<0009oo`04001oogoo000jOol000]o
o`03001oogoo019oo`<000Aoo`03001oogoo061oo`03001oogoo05Ioo`03001oo`0003Yoo`002goo
00<007ooOol06Goo00<007ooOol0HGoo00<007ooOol0EWoo0P00>Woo000;Ool00`00Oomoo`0HOol2
001SOol00`00Oomoo`2BOol000]oo`03001oogoo07ioo`03001oogoo095oo`002goo00<007ooOol0
OWoo00<007ooOol0TGoo000;Ool00`00Oomoo`1oOol00`00Oomoo`2@Ool000]oo`03001oogoo07mo
o`03001oogoo091oo`002goo00<007ooOol0P7oo00<007ooOol0Sgoo000;Ool00`00Oomoo`20Ool0
0`00Oomoo`2?Ool000]oo`03001oogoo085oo`03001oogoo08ioo`002goo00<007ooOol0PGoo00<0
07ooOol0SWoo000;Ool00`00Oomoo`21Ool00`00Oomoo`1IOol7000^Ool000]oo`03001oogoo089o
o`03001oogoo05Moo`03001oogoo00Eoo`8002aoo`002goo00<007ooOol0PWoo00<007ooOol0EWoo
00<007ooOol027oo00<007ooOol0:Goo000;Ool00`00Oomoo`23Ool00`00Oomoo`1DOol00`00Oomo
o`09Ool00`00Oomoo`0YOol000]oo`03001oogoo08=oo`03001oogoo05=oo`03001oogoo00]oo`03
001oogoo02Qoo`002goo00<007ooOol0Q7oo00<007ooOol0DGoo00<007ooOol03Goo00<007ooOol0
9goo000;Ool00`00Oomoo`24Ool00`00Oomoo`1@Ool00`00Oomoo`0?Ool00`00Oomoo`0VOol000]o
o`03001oogoo08Eoo`03001oogoo04moo`03001oogoo00moo`03001oogoo02Ioo`002goo00<007oo
Ool0QGoo00<007ooOol0CWoo00<007ooOol04Goo00<007ooOol09Goo000;Ool00`00Oomoo`26Ool0
0`00Oomoo`1<Ool00`00Oomoo`0BOol00`00Oomoo`0UOol000]oo`03001oogoo08Ioo`03001oogoo
04aoo`03001oogoo01=oo`03001oogoo02Aoo`002goo00<007ooOol0Qgoo00<007ooOol0BWoo00<0
07ooOol057oo00<007ooOol097oo000;Ool00`00Oomoo`27Ool00`00Oomoo`19Ool00`00Oomoo`0F
Ool00`00Oomoo`0SOol000]oo`03001oogoo08Qoo`03001oogoo04Moo`03001oogoo01Moo`03001o
ogoo02=oo`002goo00<007ooOol0R7oo00<007ooOol0Agoo00<007ooOol05goo00<007ooOol08goo
000;Ool00`00Oomoo`29Ool00`00Oomoo`15Ool00`00Oomoo`0IOol00`00Oomoo`0ROol000]oo`03
001oogoo08Uoo`03001oogoo04Aoo`03001oogoo01Yoo`03001oogoo029oo`002goo00<007ooOol0
RWoo00<007ooOol0@Woo00<007ooOol06goo00<007ooOol08Woo000;Ool00`00Oomoo`2:Ool00`00
Oomoo`12Ool00`00Oomoo`0LOol00`00Oomoo`0QOol000]oo`03001oogoo08]oo`03001oogoo041o
o`03001oogoo01eoo`03001oogoo025oo`002goo00<007ooOol0Rgoo00<007ooOol0@7oo00<007oo
Ool07Goo00<007ooOol08Goo000;Ool00`00Oomoo`2<Ool00`00Oomoo`0nOol00`00Oomoo`0OOol0
0`00Oomoo`0POol000]oo`03001oogoo08aoo`03001oogoo03eoo`03001oogoo021oo`03001oogoo
021oo`002goo00<007ooOol0SGoo00<007ooOol0?7oo00<007ooOol087oo00<007ooOol087oo000;
Ool00`00Oomoo`2=Ool00`00Oomoo`0kOol00`00Oomoo`0QOol00`00Oomoo`0POol000]oo`03001o
ogoo08ioo`03001oogoo03Yoo`03001oogoo029oo`03001oogoo01moo`002goo00<007ooOol0SWoo
00<007ooOol0>Goo00<007ooOol08goo00<007ooOol07goo000;Ool00`00Oomoo`2?Ool00`00Oomo
o`0gOol00`00Oomoo`0TOol00`00Oomoo`0OOol000]oo`03001oogoo08moo`03001oogoo03Moo`03
001oogoo02Aoo`03001oogoo01moo`002goo00<007ooOol0T7oo00<007ooOol0=Goo00<007ooOol0
9Woo00<007ooOol07Woo000;Ool00`00Oomoo`2@Ool00`00Oomoo`0dOol00`00Oomoo`0WOol00`00
Oomoo`0NOol000]oo`03001oogoo095oo`03001oogoo03=oo`03001oogoo02Moo`03001oogoo01io
o`002goo00<007ooOol0TGoo00<007ooOol0<Woo00<007ooOol0:7oo00<007ooOol07Woo000;Ool0
0`00Oomoo`2BOol00`00Oomoo`0aOol00`00Oomoo`0YOol00`00Oomoo`0MOol000]oo`03001oogoo
09=oo`03001oogoo02moo`03001oogoo02Yoo`03001oogoo01eoo`002goo00<007ooOol0U7oo00<0
07ooOol0;Goo00<007ooOol0:goo00<007ooOol07Goo000;Ool00`00Oomoo`2DOol00`00Oomoo`0/
Ool00`00Oomoo`0/Ool00`00Oomoo`0MOol000]oo`03001oogoo09Eoo`03001oogoo02]oo`03001o
ogoo02aoo`03001oogoo01eoo`002goo00<007ooOol0UWoo00<007ooOol0:Goo00<007ooOol0;Woo
00<007ooOol077oo000;Ool00`00Oomoo`2GOol00`00Oomoo`0WOol00`00Oomoo`0_Ool00`00Oomo
o`0LOol000]oo`03001oogoo09Moo`03001oogoo02Ioo`03001oogoo031oo`03001oogoo01aoo`00
2goo00<007ooOol0V7oo00<007ooOol09Goo00<007ooOol0<7oo00<007ooOol077oo000;Ool00`00
Oomoo`2IOol00`00Oomoo`0SOol00`00Oomoo`0aOol00`00Oomoo`0LOol000]oo`03001oogoo09Yo
o`03001oogoo025oo`03001oogoo03=oo`03001oogoo01]oo`002goo00<007ooOol0VWoo00<007oo
Ool087oo00<007ooOol0=7oo00<007ooOol06goo000;Ool00`00Oomoo`2KOol00`00Oomoo`0NOol0
0`00Oomoo`0eOol00`00Oomoo`0KOol000]oo`03001oogoo09aoo`03001oogoo01eoo`03001oogoo
03Eoo`03001oogoo01]oo`002goo00<007ooOol0WGoo00<007ooOol06goo00<007ooOol0=Woo00<0
07ooOol06goo000;Ool00`00Oomoo`2NOol00`00Oomoo`0IOol00`00Oomoo`0hOol00`00Oomoo`0J
Ool000]oo`03001oogoo09moo`03001oogoo01Ioo`8003]oo`03001oogoo01Yoo`002goo00<007oo
Ool0X7oo00<007ooOol057oo00<007ooOol0>goo00<007ooOol06Woo000;Ool00`00Oomoo`2QOol2
000BOol2000nOol00`00Oomoo`0JOol000]oo`03001oogoo0:=oo`03001oogoo00ioo`03001oogoo
03ioo`03001oogoo01Yoo`002goo00<007ooOol0Y7oo0P0037oo0P00@Goo00<007ooOol06Woo000;
Ool00`00Oomoo`2VOol20007Ool30014Ool00`00Oomoo`0IOol000]oo`03001oogoo0:Qoo`L004Mo
o`03001oogoo01Uoo`002goo00<007ooOol0mWoo00<007ooOol06Goo000;Ool00`00Oomoo`3fOol0
0`00Oomoo`0IOol000]oo`03001oogoo0?Ioo`03001oogoo01Uoo`002goo00<007ooOol0mWoo00<0
07ooOol06Goo000;Ool00`00Oomoo`3fOol00`00Oomoo`0IOol000]oo`03001oogoo0?Moo`03001o
ogoo01Qoo`002goo00<007ooOol0mgoo00<007ooOol067oo000;Ool00`00Oomoo`2EOol50002Ool2
001IOol00`00Oomoo`0HOol000]oo`03001oogoo09Eoo`@0009oo`04001oogoo001HOol00`00Oomo
o`0HOol000]oo`03001oogoo09Qoo`03001oogoo009oo`03001oogoo05Moo`03001oogoo01Qoo`00
2goo00<007ooOol0UWoo0`001Goo00<007ooOol0EWoo00<007ooOol067oo000;Ool00`00Oomoo`2K
Ool01000Oomoo`00F7oo00<007ooOol067oo000;Ool00`00Oomoo`2LOol2001JOol00`00Oomoo`0G
Ool000]oo`03001oogoo0?Qoo`03001oogoo01Moo`002goo00<007ooOol0n7oo00<007ooOol05goo
000;Ool00`00Oomoo`3hOol00`00Oomoo`0GOol000]oo`03001oogoo0?Qoo`03001oogoo01Moo`00
2goo00<007ooOol0n7oo00<007ooOol05goo000;Ool00`00Oomoo`3hOol00`00Oomoo`0GOol00001
\
\>"],
  ImageRangeCache->{{{0, 287}, {172.813, 0}} -> {-0.805305, 0.488796, \
0.0261694, 0.0261694}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Display["\<maxmin.eps\>", \ %, \ "\<EPS\>"]\)], "Input"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 680}},
WindowSize->{1016, 648},
WindowMargins->{{0, Automatic}, {Automatic, 0}}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 167, 3, 50, "Input"],
Cell[1909, 56, 383, 6, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2329, 67, 45, 1, 30, "Input"],
Cell[2377, 70, 187, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2601, 78, 298, 5, 50, "Input"],
Cell[2902, 85, 12376, 305, 175, 2802, 182, "GraphicsData", "PostScript", \
"Graphics"],
Cell[15281, 392, 130, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[15448, 400, 196, 3, 50, "Input"],
Cell[15647, 405, 212, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[15896, 413, 53, 1, 30, "Input"],
Cell[15952, 416, 16518, 464, 182, 5826, 327, "GraphicsData", "PostScript", \
"Graphics"],
Cell[32473, 882, 130, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[32640, 890, 76, 1, 30, "Input"],
Cell[32719, 893, 130, 3, 29, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

